/*-----------------------------------------------------------------------------------------------------------------------------
FileName: smallBuffer.c 
Autor:  Mathieu Gisselbrecht
Date : Creation -  Avril 2006
-----------------------------------------------------------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------------------------------------------------------
// PROJECT INCLUDE 
//-----------------------------------------------------------------------------------------------------------------------------
#include "string.h"
#include "smallBuffer.h"

//-----------------------------------------------------------------------------------------------------------------------------
// All structures are 2-byte-aligned.
#if TARGET_CPU_PPC
	#pragma options align=mac68k
#endif
#ifdef _WINDOWS_
	#pragma pack(2)
#endif

//-----------------------------------------------------------------------------------------------------------------------------
// LOCAL PROTOTYPES 
//-----------------------------------------------------------------------------------------------------------------------------
#pragma mark Local Prototypes 
void resetBuffer(TBuffer *buffer);

//-----------------------------------------------------------------------------------------------------------------------------
//  									  CODE  
//-----------------------------------------------------------------------------------------------------------------------------
#pragma mark ----------------------------
//-----------------------------------------------------------------------------------------------------------------------------
void resetBuffer(TBuffer *buffer)
{
	buffer->endofBuffer=buffer->data+BUFFER_SIZE;
	buffer->ptrBegin=buffer->data;
	buffer->ptrEnd=buffer->data;

}
//-----------------------------------------------------------------------------------------------------------------------------
void createBuffer(TBuffer *buffer, int type)
{
	buffer->type=type;
	//memcpy(buffer->mask,mask,MAX_MASK*sizeof(long));
	resetBuffer(buffer);
}
//-----------------------------------------------------------------------------------------------------------------------------
int readBuffer(TBuffer *buffer, int type, long *data)
{
	int   result=0;
	unsigned char  *ptr8Bit,data8Bit;
	unsigned short *ptr16Bit,data16Bit;
	unsigned long  *ptr32Bit;

	switch (type) {
		case 8:
				ptr8Bit=buffer->ptrBegin;
				data8Bit=*ptr8Bit;
				*data=(unsigned long)data8Bit;
				ptr8Bit++;
				if (buffer->ptrBegin==buffer->ptrEnd) goto buffer_error;
				if (ptr8Bit>=buffer->endofBuffer)  goto buffer_error;
				else buffer->ptrBegin=ptr8Bit;
			break;
		case 16:
				ptr16Bit=buffer->ptrBegin;
				data16Bit=*ptr16Bit;
				*data=(unsigned long)data16Bit;
				ptr16Bit++;
				if (buffer->ptrBegin==buffer->ptrEnd) goto buffer_error;
				if (ptr16Bit>=buffer->endofBuffer) goto buffer_error;
				else buffer->ptrBegin=ptr16Bit;
			break;
		case 24:
				ptr16Bit=buffer->ptrBegin;
				data16Bit=*ptr16Bit;
				*data=(unsigned long)data16Bit<<8;
				ptr16Bit++;
				if (buffer->ptrBegin==buffer->ptrEnd) goto buffer_error;
				if (ptr16Bit>=buffer->endofBuffer) goto buffer_error;
				else buffer->ptrBegin=ptr16Bit;
				
				ptr8Bit=buffer->ptrBegin;
				data8Bit=*ptr8Bit;
				*data+=(unsigned long)data8Bit;
				ptr8Bit++;
				if (buffer->ptrBegin==buffer->ptrEnd) goto buffer_error;
				if (ptr8Bit>=buffer->endofBuffer)  goto buffer_error;
				else buffer->ptrBegin=ptr8Bit;
			break;
		case 32:
				ptr32Bit=buffer->ptrBegin;
				*data=*ptr32Bit;
				ptr32Bit++;
				if (buffer->ptrBegin==buffer->ptrEnd) goto buffer_error;
				if (ptr32Bit>=buffer->endofBuffer) goto buffer_error;
				else buffer->ptrBegin=ptr32Bit;		
			break;
		}
	return result;

buffer_error:
	resetBuffer(buffer);
	return -1;

}
//-----------------------------------------------------------------------------------------------------------------------------
int writeBuffer(TBuffer *buffer, int type, long data)
{
	int   result=0;
	char  *ptr8Bit,data8Bit;
	short *ptr16Bit,data16Bit;
	long  *ptr32Bit;

	switch (type) {
		case 8:
				ptr8Bit=buffer->ptrEnd;
				data8Bit=(char)data;
				*ptr8Bit=data8Bit;
				ptr8Bit++;
				buffer->ptrEnd=ptr8Bit;
				if (ptr8Bit>buffer->endofBuffer) result=-1;
			break;
		case 16:
				ptr16Bit=buffer->ptrEnd;
				data16Bit=(short)data;
				*ptr16Bit=data16Bit;
				ptr16Bit++;
				buffer->ptrEnd=ptr16Bit;
				if (ptr16Bit>buffer->endofBuffer) result=-1;
			break;
		case 32:
				ptr32Bit=buffer->ptrEnd;
				*ptr32Bit=data;
				ptr32Bit++;
				buffer->ptrEnd=ptr32Bit;
				if (ptr32Bit>buffer->endofBuffer) result=-1;	
			break;
		}
	return result;
}
//-----------------------------------------------------------------------------------------------------------------------------
int ismarkerBuffer(unsigned char marker, TBuffer *buffer,int ntimes, int bits)
{ 
	unsigned char content,*offset;
	//unsigned long *addr;
	int result=0;
	
	offset=(unsigned char*)buffer->ptrBegin+ntimes*bits/8;
	//addr=(unsigned long*)offset;
	content=(unsigned char)*(offset);
	if (offset>buffer->endofBuffer) return result;
	if (content==marker) result=1;
  	return result;
}

//-----------------------------------------------------------------------------------------------------------------------------
float freespaceBuffer(TBuffer *buffer)
{	long E=(long)buffer->ptrEnd;
	long B=(long)buffer->ptrBegin;
	float diff,result;
	
	diff=E-B;
	result=diff/BUFFER_SIZE;
	return result;
}

//-----------------------------------------------------------------------------------------------------------------------------
// All structures are 2-byte-aligned.
#if TARGET_CPU_PPC
	#pragma options align=reset
#endif
#ifdef _WINDOWS_
	#pragma pack()
#endif
